### Tab Bar

The Tab Bar sits at the top of the editing pane, allowing for more than one file to be edited at a time and quick switching between text windows.  To switch to a different tab, simply left-click on any tab in the tab bar.

By default, tabs are added to the tab bar in the order they were opened; however, the user can change this order by clicking on a given tab and dragging the tab to a new position in the tab bar.  Additionally, you can sort the tabs in alphabetical order by selecting the “View / Tabs / Sort Tabs” menu item.  If you would always like tabs to be sorted in alphabetical order, you can change this behavior in the user preference file (see the Preferences chapter for information on how to edit this file).

When more files are opened than the tab bar has space to hold, the tab bar will adjust itself to show as many tabs as is comfortable to display and then display some tab shift buttons on each side of the tab bar (indicated with left and right arrows).  To view tabs off-screen to the right, click on the right button.  To view tabs off-screen to the left, click on the left button.  Alternatively, you can use your mouse’s scrolling capability with the mouse pointer within the tabbar to quickly scroll the list of tabs to the right or left.  To see a list of all opened tabs, right-click on either the left or right arrow buttons and select a file from the displayed dropdown list.  The resulting list will show an in-order list of tabs in the resulting menu with separators strategically placed, to quickly find which tabs are off-screen on each side of the currently displayed tab bar.

In addition to switching between different opened text windows, the tab bar also provides a number of other functions and visual indicators.  When a file is locked, a locked icon will be displayed on the left side of the associated tab.  If the tab contains a file in difference mode/view, a -/+ icon will be displayed on the left side of the associated tab.  When a file has been modified, an asterisk will be displayed to the left of the file name, indicating that a save is needed to commit the changes to the file.  The base name of the file is displayed in the tab along with file extension; however, if you would like to see the full pathname of the file, simply hover the mouse over any portion of the tab and a tooltip is displayed with this information.  To close the tab, move the mouse cursor over the tab and a close icon is displayed on the right side of the tab, clicking on this button will close the associated tab (if the file is closed and the text has been modified, a prompt will be displayed indicating that the file has not been saved, allowing the user to save the file).

To help eliminate tab clutter, TKE now has a tab hiding feature built into the menu, the sidebar and the tab contextual menu that allows you to hide/show tabs within the tabbar.  If a tab is hidden, its contents remain in tact (i.e., unsaved changes will exist) unlike if the tab is closed.  This tab hiding feature can help you to create focused workflows while editing without losing the file state of the hidden tabs (ex., you can still see which files are opened but hidden in the sidebar by viewing the file’s icon in the sidebar).

In addition to these functions, you can also access a drop down menu of functionality by right-clicking on a tab.  The following table summarizes this functionality.

| Menu Item | Description |
| - | - |
| Close Tab | Closes the current tab.  This is the exact same behavior as clicking on the close button within the tab. |
| Close All Other Tabs | Closes all of the other tabs in the tab bar, leaving this tab as the only opened tab in the editing pane. |
| Close All Tabs | Closes all tabs in the tab bar. |
| Close Other Tabs in Pane | Closes all of the other tabs in the current tab pane. Leaves all tabs in the other pane opened. |
| Close All Tabs in Pane | Closes all of the tabs in the current tab pane. Leaves all tabs in the other pane opened. |
| Hide Tab | Hides the current tab from view.  You can show the tab by either using the sidebar or by using the View / Tabs / Show All Tabs option. |
| Split View | Creates another editing buffer in the same tab (it is placed above the current editing buffer).  This buffer is a second view into the same file.  This allows you to view and edit two different views of the same file.  Selecting this command again will remove the second editing buffer view. |
| Bird’s Eye View | If checked, displays the bird’s eye view of the current file within a narrow ribbon on the left side of the editing buffer. This option allows the user to override the view menu option and/or preference option that controls the display of the birds’ eye view. |
| Locked | Indicator of the locked status of the file and allows the user to toggle the locked status of the file.  If a checkmark is displayed next to this item, the file is locked and cannot be modified within TKE.  If no checkmark exists, the file is modifiable. |
| Favorited | Indicator of the favorite status of the file and allows the user to toggle the favorite status of the file.  Favorited files can be quickly opened via the File / Open Favorite menu or the command launcher. |
| Show in Sidebar | Causes the current file to be displayed in the sidebar (even if the directory is not disclosed). |
| Move to Other Pane | Moves the tab and associated text window to the other editing pane, allowing for side-by-side text editing.  If the other editing pane does not exist, it will be created.  If the current tab is the only tab in the current pane and it is moved, the current pane will disappear, leaving only a single pane displayed in the editing panel.  This option will not be available if there is only one tab opened in the editing panel. |